/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.asm;

import com.google.gson.Gson;
import com.pg85.otg.configuration.standard.WorldStandardValues;
import com.pg85.otg.forge.asm.excluded.IOTGASMBiome;
import com.pg85.otg.forge.dimensions.OTGDimensionManager;
import com.pg85.otg.forge.dimensions.OTGWorldProvider;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketWorldBorder;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.border.WorldBorder;
import net.minecraftforge.common.DimensionManager;

public class OTGHooks {
    static boolean checkedOTGInstall = false;
    static boolean otgIsInstalled = false;

    private static boolean isOTGInstalled() {
        if (!checkedOTGInstall) {
            checkedOTGInstall = true;
            String isOTGInstalled = "NoClassDefFoundError";
            try {
                if (isOTGInstalled instanceof OTGWorldProvider) {
                    // empty if block
                }
                otgIsInstalled = true;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        return otgIsInstalled;
    }

    public static boolean initOTGDimension(int i) {
        if (OTGHooks.isOTGInstalled() && DimensionManager.isDimensionRegistered((int)i) && OTGDimensionManager.IsOTGDimension((int)i)) {
            OTGDimensionManager.initDimension((int)i);
            return true;
        }
        return false;
    }

    public static int getIDForObject(Biome biome) {
        if (OTGHooks.isOTGInstalled() && biome instanceof IOTGASMBiome) {
            return ((IOTGASMBiome)biome).getSavedId();
        }
        return Biome.func_185362_a((Biome)biome);
    }

    public static double getGravityFactor(Entity entity) {
        if (OTGHooks.isOTGInstalled()) {
            if (entity.field_70170_p.field_73011_w instanceof OTGWorldProvider) {
                return ((OTGWorldProvider)entity.field_70170_p.field_73011_w).getGravityFactor();
            }
            return 0.08;
        }
        return 0.08;
    }

    public static boolean isOTGWorld(Entity entity) {
        return OTGHooks.isOTGInstalled() && entity.func_130014_f_().field_73011_w instanceof OTGWorldProvider;
    }

    public static double getGravityFactorMineCart(Entity entity) {
        if (OTGHooks.isOTGInstalled() && entity.field_70170_p.field_73011_w instanceof OTGWorldProvider) {
            double baseGravityFactor = (Double)WorldStandardValues.GravityFactor.getDefaultValue();
            double gravityFactor = ((OTGWorldProvider)entity.field_70170_p.field_73011_w).getGravityFactor();
            return (double)0.04f * (gravityFactor / baseGravityFactor);
        }
        return 0.04f;
    }

    public static double getGravityFactorArrow(Entity entity) {
        if (OTGHooks.isOTGInstalled() && entity.field_70170_p.field_73011_w instanceof OTGWorldProvider) {
            double baseGravityFactor = (Double)WorldStandardValues.GravityFactor.getDefaultValue();
            double gravityFactor = ((OTGWorldProvider)entity.field_70170_p.field_73011_w).getGravityFactor();
            return (double)0.05f * (gravityFactor / baseGravityFactor);
        }
        return 0.05f;
    }

    public static double getGravityFactorBoat(Entity entity) {
        if (OTGHooks.isOTGInstalled() && entity.field_70170_p.field_73011_w instanceof OTGWorldProvider) {
            double baseGravityFactor = (Double)WorldStandardValues.GravityFactor.getDefaultValue();
            double gravityFactor = ((OTGWorldProvider)entity.field_70170_p.field_73011_w).getGravityFactor();
            return (double)-0.04f * (gravityFactor / baseGravityFactor);
        }
        return -0.04f;
    }

    public static double getGravityFactorFallingBlock(Entity entity) {
        if (OTGHooks.isOTGInstalled() && entity.field_70170_p.field_73011_w instanceof OTGWorldProvider) {
            double baseGravityFactor = (Double)WorldStandardValues.GravityFactor.getDefaultValue();
            double gravityFactor = ((OTGWorldProvider)entity.field_70170_p.field_73011_w).getGravityFactor();
            return (double)0.04f * (gravityFactor / baseGravityFactor);
        }
        return 0.04f;
    }

    public static double getGravityFactorItem(Entity entity) {
        if (OTGHooks.isOTGInstalled() && entity.field_70170_p.field_73011_w instanceof OTGWorldProvider) {
            double baseGravityFactor = (Double)WorldStandardValues.GravityFactor.getDefaultValue();
            double gravityFactor = ((OTGWorldProvider)entity.field_70170_p.field_73011_w).getGravityFactor();
            return (double)0.04f * (gravityFactor / baseGravityFactor);
        }
        return 0.04f;
    }

    public static double getGravityFactorLlamaSpit(Entity entity) {
        if (OTGHooks.isOTGInstalled() && entity.field_70170_p.field_73011_w instanceof OTGWorldProvider) {
            double baseGravityFactor = (Double)WorldStandardValues.GravityFactor.getDefaultValue();
            double gravityFactor = ((OTGWorldProvider)entity.field_70170_p.field_73011_w).getGravityFactor();
            return (double)0.06f * (gravityFactor / baseGravityFactor);
        }
        return 0.06f;
    }

    public static double getGravityFactorShulkerBullet(Entity entity) {
        if (OTGHooks.isOTGInstalled() && entity.field_70170_p.field_73011_w instanceof OTGWorldProvider) {
            double baseGravityFactor = (Double)WorldStandardValues.GravityFactor.getDefaultValue();
            double gravityFactor = ((OTGWorldProvider)entity.field_70170_p.field_73011_w).getGravityFactor();
            return 0.04 * (gravityFactor / baseGravityFactor);
        }
        return 0.04;
    }

    public static float getGravityFactorThrowable(Entity entity) {
        if (OTGHooks.isOTGInstalled() && entity.field_70170_p.field_73011_w instanceof OTGWorldProvider) {
            double baseGravityFactor = (Double)WorldStandardValues.GravityFactor.getDefaultValue();
            double gravityFactor = ((OTGWorldProvider)entity.field_70170_p.field_73011_w).getGravityFactor();
            return (float)((double)0.03f * (gravityFactor / baseGravityFactor));
        }
        return 0.03f;
    }

    public static double getGravityFactorTNTPrimed(Entity entity) {
        if (OTGHooks.isOTGInstalled() && entity.field_70170_p.field_73011_w instanceof OTGWorldProvider) {
            double baseGravityFactor = (Double)WorldStandardValues.GravityFactor.getDefaultValue();
            double gravityFactor = ((OTGWorldProvider)entity.field_70170_p.field_73011_w).getGravityFactor();
            return (double)0.04f * (gravityFactor / baseGravityFactor);
        }
        return 0.04f;
    }

    public static double getGravityFactorXPOrb(Entity entity) {
        if (OTGHooks.isOTGInstalled() && entity.field_70170_p.field_73011_w instanceof OTGWorldProvider) {
            double baseGravityFactor = (Double)WorldStandardValues.GravityFactor.getDefaultValue();
            double gravityFactor = ((OTGWorldProvider)entity.field_70170_p.field_73011_w).getGravityFactor();
            return (double)0.03f * (gravityFactor / baseGravityFactor);
        }
        return 0.03f;
    }

    public static int countMissingRegistryEntries(LinkedHashMap<ResourceLocation, Map<ResourceLocation, Integer>> missing) {
        int count;
        if (OTGHooks.isOTGInstalled() && missing.containsKey(new ResourceLocation("minecraft", "biomes"))) {
            Gson gson = new Gson();
            ArrayList<ResourceLocation> biomesToRemove = new ArrayList<ResourceLocation>();
            Map<ResourceLocation, Integer> biomes = missing.get(new ResourceLocation("minecraft", "biomes"));
            for (ResourceLocation biomeResourceLocation : biomes.keySet()) {
                String jsonInString;
                if (biomeResourceLocation == null || !(jsonInString = gson.toJson((Object)biomeResourceLocation)).contains(":\"openterraingenerator\",")) continue;
                biomesToRemove.add(biomeResourceLocation);
            }
            for (ResourceLocation biomeResourceLocation : biomesToRemove) {
                biomes.remove(biomeResourceLocation);
            }
        }
        if ((count = missing.values().stream().mapToInt(Map::size).sum()) > 0) {
            System.out.println("Items/Blocks/Biomes appear to be missing from the registry. Forge will show an error message about this and you will not be able to join the world. Forge will display a list of missing registry entries, you can ignore any otg biomes on that list as they do not actually need to be registered. The missing registries error is caused by other mods, not OTG.");
        }
        return count;
    }

    public static WorldBorder getWorldBorder(WorldBorder worldBorder, WorldServer worldIn) {
        if (OTGHooks.isOTGInstalled() && worldIn.field_73011_w instanceof OTGWorldProvider) {
            return worldIn.field_175728_M;
        }
        return worldBorder;
    }

    public static void setPlayerManager(final WorldServer[] worldServers) {
        worldServers[0].func_175723_af().func_177737_a(new IBorderListener(){

            public void func_177694_a(WorldBorder border, double newSize) {
                Integer[] integerArray = DimensionManager.getIDs();
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int dim = integerArray[i];
                    if (dim != 0 && OTGDimensionManager.IsOTGDimension((int)dim)) continue;
                    worldServers[0].func_73046_m().func_184103_al().func_148537_a((Packet)new SPacketWorldBorder(border, SPacketWorldBorder.Action.SET_SIZE), dim);
                }
            }

            public void func_177692_a(WorldBorder border, double oldSize, double newSize, long time) {
                Integer[] integerArray = DimensionManager.getIDs();
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int dim = integerArray[i];
                    if (dim != 0 && OTGDimensionManager.IsOTGDimension((int)dim)) continue;
                    worldServers[0].func_73046_m().func_184103_al().func_148537_a((Packet)new SPacketWorldBorder(border, SPacketWorldBorder.Action.LERP_SIZE), dim);
                }
            }

            public void func_177693_a(WorldBorder border, double x, double z) {
                Integer[] integerArray = DimensionManager.getIDs();
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int dim = integerArray[i];
                    if (dim != 0 && OTGDimensionManager.IsOTGDimension((int)dim)) continue;
                    worldServers[0].func_73046_m().func_184103_al().func_148537_a((Packet)new SPacketWorldBorder(border, SPacketWorldBorder.Action.SET_CENTER), dim);
                }
            }

            public void func_177691_a(WorldBorder border, int newTime) {
                Integer[] integerArray = DimensionManager.getIDs();
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int dim = integerArray[i];
                    if (dim != 0 && OTGDimensionManager.IsOTGDimension((int)dim)) continue;
                    worldServers[0].func_73046_m().func_184103_al().func_148537_a((Packet)new SPacketWorldBorder(border, SPacketWorldBorder.Action.SET_WARNING_TIME), dim);
                }
            }

            public void func_177690_b(WorldBorder border, int newDistance) {
                Integer[] integerArray = DimensionManager.getIDs();
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int dim = integerArray[i];
                    if (dim != 0 && OTGDimensionManager.IsOTGDimension((int)dim)) continue;
                    worldServers[0].func_73046_m().func_184103_al().func_148537_a((Packet)new SPacketWorldBorder(border, SPacketWorldBorder.Action.SET_WARNING_BLOCKS), dim);
                }
            }

            public void func_177696_b(WorldBorder border, double newAmount) {
            }

            public void func_177695_c(WorldBorder border, double newSize) {
            }
        });
    }
}

